% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgweibull.R
\name{pgweibull}
\alias{pgweibull}
\alias{spgweibull}
\alias{hpgweibull}
\alias{ppgweibull}
\alias{dpgweibull}
\alias{qpgweibull}
\alias{rpgweibull}
\title{Power generalized Weibull distribution}
\usage{
spgweibull(x, scale = 1, shape = 1, powershape = 1, log = FALSE)

hpgweibull(x, scale = 1, shape = 1, powershape = 1, log = FALSE)

ppgweibull(x, scale = 1, shape = 1, powershape = 1,
           lower.tail = TRUE, log.p = FALSE)

dpgweibull(x, scale = 1, shape = 1, powershape = 1, log = FALSE)

qpgweibull(p, scale = 1, shape = 1, powershape = 1)

rpgweibull(n, scale = 1, shape = 1, powershape = 1)
}
\arguments{
\item{x}{vector of quantiles}

\item{scale}{positive scale parameter}

\item{shape}{positive shape parameter}

\item{powershape}{positive power shape parameter}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\value{
\code{dpgweibull} gives the density, \code{ppgweibull} gives the distribution function, \code{qpgweibull} gives the quantile function, and \code{rpgweibull} generates random deviates.
\code{spgweibull} gives the survival function and \code{hpgweibull} gives the hazard function.
}
\description{
Survival, hazard, cumulative distribution,
density, quantile and sampling function for the power generalized
Weibull (PgW) distribution with parameters \code{scale}, \code{shape} and \code{powershape}.
}
\details{
The survival function of the PgW distribution is:
\deqn{
    S(x) = \exp \left\{ 1 - \left[ 1 + \left(\frac{x}{\theta}\right)^{\nu}\right]^{\frac{1}{\gamma}} \right\}.
}
The hazard function is
\deqn{
\frac{\nu}{\gamma\theta^{\nu}}\cdot x^{\nu-1}\cdot  \left[ 1 + \left(\frac{x}{\theta}\right)^{\nu}\right]^{\frac{1}{\gamma-1}}
}
The cumulative distribution function is then \eqn{F(x) = 1 - S(x)} and the density function
is \eqn{S(x)\cdot h(x)}.

If both shape parameters equal 1, the PgW distribution reduces to the exponential distribution
(see \code{\link[stats]{dexp}}) with \eqn{\texttt{rate} = 1/\texttt{scale}}
If the power shape parameter equals 1, the PgW distribution simplifies to the Weibull distribution
(see \code{\link[stats]{dweibull}}) with the same parametrization.
}
\examples{
x <- rpgweibull(1, 2, 2, 3)
d <- dpgweibull(x, 2, 2, 3)
p <- ppgweibull(x, 2, 2, 3)
q <- qpgweibull(p, 2, 2, 3)
s <- spgweibull(x, 2, 2, 3)
h <- hpgweibull(x, 2, 2, 3)
}
