% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENphylo_results.R
\name{getENphylo_results}
\alias{getENphylo_results}
\title{Import ENphylo_modeling results into global environment}
\usage{
getENphylo_results(input.dir,mods="all",species_name=NULL,only_evaluations=FALSE)
}
\arguments{
\item{input.dir}{the file path wherein the folders "ENphylo_enfa_models" and
"ENphylo_imputed_models" generated by \code{\link{ENphylo_modeling}}
are stored.}

\item{mods}{character. Name of the models to be retrieved. Viable options are:
\code{“enfa”} (enfa models), \code{“enphylo”} (ENphylo models), \code{“all”}
(default, enfa plus ENphylo models).}

\item{species_name}{character. The name of the single (or multiple) species
for which model results must be imported.}

\item{only_evaluations}{logical. If TRUE, \code{getENphylo_results} returnes
model performances only.}
}
\value{
A named list of outputs as described in
 \code{\link{ENphylo_modeling}}.
}
\description{
The function retrieves the ENFA/ENphylo models generated by
 \code{\link{ENphylo_modeling}} and arranges them into a named list to be
 used in \code{\link{ENphylo_prediction}} function. It also offers the option
 to choose between retrieving ENFA or ENphylo models and to select the model
 produced for one or more focal species.
}
\examples{
\dontrun{
library(ape)
library(terra)
library(sf)
library(RRgeo)

newwd<-tempdir()
# newwd<-"YOUR_DIRECTORY"
latesturl<-RRgeo:::get_latest_version("12734585")
curl::curl_download(url = paste0(latesturl,"/files/dat.Rda?download=1"),
                    destfile = file.path(newwd,"dat.Rda"), quiet = FALSE)
load(file.path(newwd,"dat.Rda"))
read.tree(system.file("exdata/Eucopdata_tree.txt", package="RRgeo"))->tree
tree$tip.label<-gsub("_"," ",tree$tip.label)
curl::curl_download(paste0(latesturl,"/files/X35kya.tif?download=1"),
                    destfile = file.path(newwd,"X35kya.tif"), quiet = FALSE)
rast(file.path(newwd,"X35kya.tif"))->map35
project(map35,st_crs(dat[[1]])$proj4string,res = 50000)->map

ENphylo_modeling(input_data=dat[c(1,11)],
                 tree=tree,
                 input_mask=map[[1]],
                 obs_col="OBS",
                 time_col="age",
                 min_occ_enfa=15,
                 boot_test_perc=20,
                 boot_reps=10,
                 swap.args=list(nsim=5,si=0.2,si2=0.2),
                 eval.args=list(eval_metric_for_imputation="AUC",
                                eval_threshold=0.7,
                                output_options="best"),
                 clust=NULL,
                 output.dir=newwd)

getENphylo_results(input.dir =newwd,
                   mods="all",
                   species_name=names(dat)[c(1,11)])->mod

}
}
\seealso{
\link{ENphylo_modeling}; \href{../doc/ENphylo.html}{\code{getENphylo_results} vignette}
}
\author{
Alessandro Mondanaro, Silvia Castiglione, Pasquale Raia
}
