% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferenceFunk.R
\name{logLikelihood_BaM}
\alias{logLikelihood_BaM}
\title{BaM log-likelihood}
\usage{
logLikelihood_BaM(
  parvector,
  X,
  Yobs,
  Yu,
  llfunk,
  mod,
  Ysim = NULL,
  llargs = NULL
)
}
\arguments{
\item{parvector}{numeric vector, parameter vector, including thetas (model parameters)
and gammas (structural errors parameters).}

\item{X}{data frame, model inputs.}

\item{Yobs}{data frame, corresponding observed values.}

\item{Yu}{data frame, measurement uncertainties (standard deviations), same dimensions as Yobs.}

\item{llfunk}{function, function computing the log-likelihood given Ysim, see e.g. \link[RBaM]{llfunk_iid_Gaussian}.}

\item{mod}{model object, the model to be calibrated.}

\item{Ysim}{data frame, model-simulated values. When NULL (default), the model is run to provide simulations.
When a non-NULL data frame is provided, it is used as pre-computed simulations, and the model is
hence not run. This is useful to speed-up some MCMC strategies.}

\item{llargs}{object, any other arguments to be passed to llfunk.}
}
\value{
A list with the following components:
    \item{logLikelihood}{numeric, the log-likelihood.}
    \item{Ysim}{data frame, the model-simulated values.}
}
\description{
Log-likelihood engine for a model available in BaM. Unlike functions llfunk_***,
which compute the log-likelihood from model-simulated values Ysim (see e.g. \link[RBaM]{llfunk_iid_Gaussian}),
this function computes the log-likelihood from (parameters + inputs X + model mod).
}
\examples{
# Single-control rating curve model - see https://github.com/BaM-tools/RBaM
# Parameters are activation stage k, coefficient a and exponent c
k=parameter(name='k',init=-0.5)
a=parameter(name='a',init=100)
c=parameter(name='c',init=1.6)
# Define control matrix: columns are controls, rows are stage ranges.
controlMatrix=matrix(1,nrow=1,ncol=1)
# Stitch it all together into a model object
M=model(ID='BaRatin',
        nX=1,nY=1, # number of input/output variables
        par=list(k,a,c), # list of model parameters
        xtra=xtraModelInfo(object=controlMatrix)) # use xtraModelInfo() to pass the control matrix
# Define calibration data
X=SauzeGaugings['H']
Yobs=SauzeGaugings['Q']
Yu=SauzeGaugings['uQ']
# Define the parameter vector (model parameters + structural error parameters)
parvector=c(RBaM::getInitPar(M$par),c(1,0.1))
# Compute log-likelihood
logLikelihood_BaM(parvector=parvector,X=X,Yobs=Yobs,Yu=Yu,
                  llfunk=llfunk_iLinear_Gaussian,mod=M)
}
