% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{penguins_df}
\alias{penguins_df}
\title{Size Measurements for Adult Foraging Penguins near Palmer Station, Antarctica}
\format{
A data frame with 344 observations and 8 variables:
\describe{
  \item{species}{Penguin species (factor with 3 levels).}
  \item{island}{Island of observation (factor with 3 levels).}
  \item{bill_length_mm}{Bill length in millimeters (numeric).}
  \item{bill_depth_mm}{Bill depth in millimeters (numeric).}
  \item{flipper_length_mm}{Flipper length in millimeters (integer).}
  \item{body_mass_g}{Body mass in grams (integer).}
  \item{sex}{Sex of the penguin (factor with 2 levels).}
  \item{year}{Year of observation (integer).}
}
}
\source{
Data taken from the palmerpenguins package version 0.1.1
}
\usage{
data(penguins_df)
}
\description{
This dataset, penguins_df, is a data frame with measurements on adult penguins from three species
and three islands in the Palmer Archipelago, Antarctica. Variables include flipper length, body mass,
bill length and depth, sex, and year of observation. Some observations may contain missing values.
}
\details{
The columns in penguins_df are a subset of those in the more extensive penguins_raw data frame,
which also includes nesting observations and blood isotope data. There are differences in column names
and data types between the two datasets. See the \emph{Format} section for details.

The dataset name has been kept as 'penguins_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PenguinR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
