% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_obwoe.R
\name{obwoe_algorithm}
\alias{obwoe_algorithm}
\title{Binning Algorithm Parameter}
\usage{
obwoe_algorithm(values = NULL)
}
\arguments{
\item{values}{A character vector of algorithm names to include in the
parameter space. If \code{NULL} (default), includes all 29 algorithms
(28 specific algorithms plus \code{"auto"}).}
}
\value{
A \code{dials} qualitative parameter object.
}
\description{
A qualitative tuning parameter for selecting the optimal binning algorithm
in \code{\link{step_obwoe}}.
}
\details{
The algorithms are organized into three groups:

\strong{Universal} (support both numerical and categorical features):
\code{"auto"}, \code{"jedi"}, \code{"jedi_mwoe"}, \code{"cm"}, \code{"dp"},
\code{"dmiv"}, \code{"fetb"}, \code{"mob"}, \code{"sketch"}, \code{"udt"}

\strong{Numerical only}:
\code{"bb"}, \code{"ewb"}, \code{"fast_mdlp"}, \code{"ir"}, \code{"kmb"},
\code{"ldb"}, \code{"lpdb"}, \code{"mblp"}, \code{"mdlp"}, \code{"mrblp"},
\code{"oslp"}, \code{"ubsd"}

\strong{Categorical only}:
\code{"gmb"}, \code{"ivb"}, \code{"mba"}, \code{"milp"}, \code{"sab"},
\code{"sblp"}, \code{"swb"}

When tuning with mixed feature types, consider restricting \code{values}
to universal algorithms only.
}
\examples{
# Default: all algorithms
obwoe_algorithm()

# Restrict to universal algorithms for mixed data
obwoe_algorithm(values = c("jedi", "mob", "dp", "cm"))

# Numerical-only algorithms
obwoe_algorithm(values = c("mdlp", "fast_mdlp", "ewb", "ir"))

}
\seealso{
\code{\link{step_obwoe}}, \code{\link{obwoe}}
}
