% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostic-quantities}
\alias{diagnostic-quantities}
\alias{log_posterior}
\alias{nuts_params}
\alias{rhat}
\alias{neff_ratio}
\alias{log_posterior.blrmfit}
\alias{nuts_params.blrmfit}
\alias{rhat.blrmfit}
\alias{neff_ratio.blrmfit}
\title{Extract Diagnostic Quantities of \pkg{OncoBayes2} Models}
\usage{
\method{log_posterior}{blrmfit}(object, ...)

\method{nuts_params}{blrmfit}(object, pars = NULL, ...)

\method{rhat}{blrmfit}(object, pars = NULL, ...)

\method{neff_ratio}{blrmfit}(object, pars = NULL, ...)
}
\arguments{
\item{object}{A \code{blrmfit} or \code{blrmtrial} object.}

\item{...}{Arguments passed to individual methods.}

\item{pars}{An optional character vector of parameter names.
For \code{nuts_params} these will be NUTS sampler parameter
names rather than model parameters. If \code{pars} is omitted
all parameters are included.}
}
\value{
The exact form of the output depends on the method.
}
\description{
Extract quantities that can be used to diagnose sampling behavior
of the algorithms applied by \pkg{Stan} at the back-end of
\pkg{OncoBayes2}.
}
\details{
For more details see
\code{\link[bayesplot:bayesplot-extractors]{bayesplot::bayesplot-extractors()}}.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(
  OncoBayes2.MC.warmup = 10, OncoBayes2.MC.iter = 20, OncoBayes2.MC.chains = 1,
  OncoBayes2.MC.save_warmup = FALSE
)

example_model("single_agent", silent = TRUE)

head(log_posterior(blrmfit))

np <- nuts_params(blrmfit)
str(np)
# extract the number of divergence transitions
sum(subset(np, Parameter == "divergent__")$Value)

head(rhat(blrmfit))
head(neff_ratio(blrmfit))

## Recover user set sampling defaults
options(.user_mc_options)

}
