% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{diversity}
\alias{diversity}
\title{Sparse implementation of Alpha Diversity Metrics}
\usage{
diversity(
  x,
  metric = c("shannon", "simpson", "invsimpson"),
  normalize = TRUE,
  base = exp(1)
)
}
\arguments{
\item{x}{A \link[base]{matrix}, \link[Matrix]{sparseMatrix} or \link[Matrix]{Matrix}.}

\item{metric}{A character variable for metric; shannon, simpson or invsimpson.}

\item{normalize}{A boolean variable for sample normalization by column sums.}

\item{base}{Input for \link[base]{log} to use natural logarithmic scale, log2, log10 or other.}
}
\value{
A numeric vector with type double.
}
\description{
Computes the alpha diversity based on Shannon index, simpson or invsimpson.
Code is adapted from \link[vegan]{diversity} and uses \link[Matrix]{sparseMatrix} in triplet format over the dense matrix.
The code is much faster and memory efficient, while still being mathematically correct.
This function is built into the class \link{omics} with method \code{alpha_diversity()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
n_row <- 1000
n_col <- 100
density <- 0.2
num_entries <- n_row * n_col
num_nonzero <- round(num_entries * density)

set.seed(123)
positions <- sample(num_entries, num_nonzero, replace=FALSE)
row_idx <- ((positions - 1) \%\% n_row) + 1
col_idx <- ((positions - 1) \%/\% n_row) + 1

values <- runif(num_nonzero, min = 0, max = 1)
sparse_mat <- sparseMatrix(
  i = row_idx,
  j = col_idx,
  x = values,
  dims = c(n_row, n_col)
)

# Alpha diversity is computed on column level
## Transpose the sparseMatrix if required with t() from Matrix R package.
result <- OmicFlow::diversity(
  x = sparse_mat,
  metric = "shannon"
) 
}
\seealso{
\link[vegan]{diversity}
}
