% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionLift}
\alias{getPredictionLift}
\title{Extract model lift at given model sensitivity}
\usage{
getPredictionLift(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  modelDesignIds = NULL,
  performanceIds = NULL,
  sensitivity = 0.1
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{modelDesignIds}{(optional) restrict to the input modelDesignIds}

\item{performanceIds}{(optional) restrict to the input performanceIds}

\item{sensitivity}{(default 0.1) the lift at the threshold with the sensitivity closest to this value is return}
}
\value{
Returns a data.frame with the columns: modelDesignId, performanceId, evaluation, sensitivity, outcomeCount, positivePredictiveValue, outcomeRate and lift.
}
\description{
This function extracts the model lift (PPV/outcomeRate)
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) modelDesignIds or performanceIds to filter to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

liftsAt0p15 <- getPredictionLift(
  connectionHandler = connectionHandler, 
  schema = 'main', 
  sensitivity = 0.15
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
