% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionDiagnosticTable}
\alias{getPredictionDiagnosticTable}
\title{Extract specific diagnostic table}
\usage{
getPredictionDiagnosticTable(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  table = "diagnostic_participants",
  diagnosticId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{table}{The table to extract}

\item{diagnosticId}{(optional) restrict to the input diagnosticId}
}
\value{
Returns a data.frame with the specified table
}
\description{
This function extracts the specified diagnostic table
}
\details{
Specify the connectionHandler, the resultDatabaseSettings, the table of interest and (optionally) a diagnosticId to filter to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

diagPred <- getPredictionDiagnosticTable(
  connectionHandler = connectionHandler, 
  schema = 'main',
  table = 'diagnostic_predictors'
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
