\name{reactorpump}
\alias{reactorpump}
\title{Failure Time Intervals of Secondary Reactor Pumps}

\description{
This dataset contains the time intervals between failures (in thousands of
hours) of secondary reactor pumps. The data were reported by Salman
Suprawhardana, Prayoto, and Sangadji (1999) and later analyzed in Bebbington,
Lai, and Zitikis (2007) in the context of flexible Weibull extensions.
}

\usage{
reactorpump
}

\format{
A numeric vector of length 23 containing time intervals between pump failures,
measured in thousands of hours.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 23 observed time intervals between successive failures
of secondary reactor pumps, measured in thousands of operating hours. Each
value represents the elapsed time between two consecutive failure events for
a pump component. The dataset is commonly used in reliability engineering and
survival analysis for modeling lifetime distributions, studying hazard rate
shapes, and evaluating the flexibility of parametric failure-time models.
}

\details{
These data are commonly used in the reliability engineering literature,
particularly for assessing lifetime distributions, hazard shapes, and model
flexibility in mechanical systems. The pump failure times originate from
components of the RSG-GAS reactor.
}

\references{
Bebbington, M., Lai, C.-D., & Zitikis, R. (2007). A flexible Weibull extension.
\emph{Reliability Engineering and System Safety}, 92, 719--726.

Salman Suprawhardana, M., Prayoto, & Sangadji (1999). Total time on test plot
analysis for mechanical components of the RSG-GAS reactor.
\emph{Atom Indones}, 25(2).
}

\examples{
summary(reactorpump)

plot(
  reactorpump,
  type = "b",
  main = "Reactor Pump Failure Intervals",
  ylab = "Thousands of Hours",
  xlab = "Observation"
)

hist(
  reactorpump,
  main = "Histogram of Failure Intervals",
  xlab = "Thousands of Hours"
)
}

\keyword{datasets}
