% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-Ldk.R
\name{Ldk}
\alias{Ldk}
\alias{LdkCoe}
\title{Builds an Ldk object}
\usage{
Ldk(coo, fac = dplyr::tibble(), links = NULL, slidings = NULL)
}
\arguments{
\item{coo}{a \code{list} of matrices of (x; y) coordinates,
or an array, or an Ldk object or a data.frame (and friends)}

\item{fac}{(optionnal) a \code{data.frame} of factors and/or numerics
specifying the grouping structure}

\item{links}{(optionnal) a 2-columns \code{matrix} of 'links' between landmarks, mainly for plotting}

\item{slidings}{(optionnal) a 3-columns \code{matrix} defining (if any) sliding landmarks}
}
\value{
an \code{Ldk} object
}
\description{
In Momocs, \code{Ldk} classes objects are
lists of configurations of \bold{l}an\bold{d}mar\bold{k}s, with optionnal components,
on which generic methods such as plotting methods (e.g. \link{stack})
and specific methods (e.g. \link{fgProcrustes}).
\code{Ldk} objects are primarily \code{\link{Coo}} objects. In a sense, morphometrics methods
on Ldk objects preserves (x, y) coordinates and \code{LdkCoe} are also \code{Ldk} objects.
}
\details{
All the shapes in x must have the same number of landmarks. If you are
trying to make an Ldk object from an Out or an Opn object, try \link{coo_sample} beforehand
to homogeneize the number of coordinates among shapes.
Please note that Ldk methods are as experimental.

implementation of \code{$slidings} is inspired by \code{geomorph}
}
\examples{
#Methods on Ldk
methods(class=Ldk)

str(mosquito)
}
\seealso{
Other classes: 
\code{\link{Coe}()},
\code{\link{Coo}()},
\code{\link{Opn}()},
\code{\link{OpnCoe}()},
\code{\link{Out}()},
\code{\link{OutCoe}()},
\code{\link{TraCoe}()}
}
\concept{classes}
