% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_mrt_effect_size.R
\name{calculate_mrt_effect_size}
\alias{calculate_mrt_effect_size}
\title{Calculate standardized proximal treatment effect across time (continuous outcomes)}
\usage{
calculate_mrt_effect_size(
  data,
  id,
  outcome,
  treatment,
  time,
  rand_prob,
  availability,
  covariates = NULL,
  smooth = TRUE,
  loess_span = 0.25,
  loess_degree = 1,
  do_bootstrap = TRUE,
  boot_replications = 1000,
  confidence_alpha = 0.05
)
}
\arguments{
\item{data}{A data.frame of MRT data (see `data_example_for_standardized_effect`)}

\item{id}{Column name for participant id}

\item{outcome}{Column name for the continuous proximal outcome}

\item{treatment}{Column name for treatment indicator}

\item{time}{Column name for time / decision point}

\item{rand_prob}{Column name for randomization probability}

\item{availability}{Column name for availability indicator}

\item{covariates}{Optional character vector of covariate column names}

\item{smooth}{Logical; apply LOESS smoothing across time}

\item{loess_span}{Numeric; smoother span}

\item{loess_degree}{Numeric; polynomial degree in LOESS}

\item{do_bootstrap}{Logical; whether to perform bootstrap over participants}

\item{boot_replications}{Integer; number of bootstrap replications}

\item{confidence_alpha}{Numeric; two-sided alpha level for CIs}
}
\value{
A data.frame of class \code{"mrt_effect_size"} containing the
  standardized effect for a continuous proximal outcome with columns:
  \describe{
    \item{time}{Decision point index.}
    \item{beta_hat}{Raw (unsmoothed) estimated excursion effect at each time.}
    \item{s_hat}{Raw (unsmoothed) estimated outcome scale at each time.}
    \item{beta_sm}{Smoothed excursion effect across time (equals \code{beta_hat}
      if \code{smooth = FALSE}).}
    \item{s_sm}{Smoothed outcome scale across time (equals \code{s_hat}
      if \code{smooth = FALSE}).}
    \item{estimate}{Standardized effect \code{beta_sm / s_sm}.}
    \item{lower}{Lower confidence bound for \code{estimate} (NA if
      \code{do_bootstrap = FALSE}).}
    \item{upper}{Upper confidence bound for \code{estimate} (NA if
      \code{do_bootstrap = FALSE}).}
  }
}
\description{
Estimates the time-varying standardized proximal causal excursion effect for
**continuous** proximal outcomes in a micro-randomized trial. The estimator
uses inverse-probability weighting and can adjust for baseline and
time-varying covariates to improve efficiency. Optionally, the effect and
scale estimates are smoothed over decision points using LOESS, and
participant-level bootstrap confidence intervals can be computed.
}
\examples{
data("data_example_for_standardized_effect")

ans_ci <- calculate_mrt_effect_size(
  data         = data_example_for_standardized_effect,
  id           = "id",
  outcome      = "outcome",
  treatment    = "treatment",
  time         = "decision_point",
  rand_prob    = "prob_treatment",
  availability = "availability",
  covariates   = c("covariate1", "covariate2"),
  do_bootstrap = TRUE,
  boot_replications = 100
)

# Note: use at least 1000 bootstrap replications for stable CIs.

summary(ans_ci)
plot(ans_ci)
}
\references{
Luers, B., Klasnja, P., and Murphy, S. (2019).
Standardized effect sizes for preventive mobile health interventions in
micro-randomized trials. *Prevention Science*, 20(1), 100–109.
}
