% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alpha_diversity_calculator2.R
\name{Alpha_diversity_calculator2}
\alias{Alpha_diversity_calculator2}
\title{Calculate alpha diversity based on tax summary object or dataframe table}
\usage{
Alpha_diversity_calculator2(
  taxobj = NULL,
  taxlevel = NULL,
  prefix = "",
  input,
  inputformat,
  reads
)
}
\arguments{
\item{taxobj}{tax summary objects computed by \code{\link{tax_summary}}. Default:NULL.}

\item{taxlevel}{taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").Default:NULL.}

\item{prefix}{A character string as prefix of diversity index. Default:""}

\item{input}{Reads or relative abundance of OTU/Taxa/gene data frame,see details in inputformat. (Useless when taxobj is set).}

\item{inputformat}{(Useless when taxobj is set)
1:data frame with first column of OTUID and last column of taxonomy

2:data frame with first column of OTUID/taxonomy

3:data frame of all numeric}

\item{reads}{If the input data frame were from reads table or not(relative abundance table).(Useless when taxobj is set).}
}
\value{
when tax taxobj is set, returns column table with group information combined with for alpha-diversity of each sample,else returns data frame for alpha-diversity of each sample
}
\description{
Calculate alpha diversity of each sample
}
\note{
1.When input data frame is in relative abundance table,Chao and ACE are not available
}
\examples{
### Data preparation ####
data(testotu)
groupinformation <- data.frame(
  group = c(rep("a", 10), rep("b", 10)),
  factor1 = rnorm(10),
  factor2 = rnorm(mean = 100, 10),
  subject = factor(c(1:10, 1:10))
)

# Summary OTU table into genus table and phylum table
testtax_summary <- tax_summary(
  groupfile = groupinformation,
  inputtable = testotu[, 2:21],
  reads = TRUE,
  taxonomytable = testotu[, c(1, 22)]
)

### Use taxsummary object as input ###
Alpha <- Alpha_diversity_calculator2(
  taxobj = testtax_summary,
  taxlevel = "Base"
)
head(Alpha)

# In genus level
Alpha <- Alpha_diversity_calculator2(
  taxobj = testtax_summary,
  taxlevel = "Genus",
  prefix = "Genus"
)
head(Alpha)

### Input dataframe from reads table ###
Alpha <- Alpha_diversity_calculator2(
  input = testotu,
  prefix = "Bacterial",
  inputformat = 1,
  reads = TRUE
)

### Input dataframe from relative abundance table ###
if (!require(magrittr)) install.packages("magrittr")
library(magrittr)
Alpha <- Filter_function(
  input = testotu,
  threshold = 0,
  format = 1
) \%>\%
  Alpha_diversity_calculator2(
    input = .,
    prefix = "Bacterial",
    inputformat = 1,
    reads = FALSE
  )
head(Alpha)
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
