% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{abacus.plot}
\alias{abacus.plot}
\title{Create an abacus plot
Creates an abacus plot, depicting visits per subject over time}
\usage{
abacus.plot(
  n,
  time,
  id,
  data,
  tmin,
  tmax,
  xlab.abacus = "Time",
  ylab.abacus = "Subject",
  pch.abacus = 16,
  col.abacus = 1
)
}
\arguments{
\item{n}{the number of subjects to randomly sample. Subjects are sampled without replacement and therefore n must be smaller than the total number of subjects in the dataset}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{id}{character string indicating which column of the data identifies subjects}

\item{data}{data frame containing the variables in the model}

\item{tmin}{the smallest time to include on the x-axis}

\item{tmax}{the largest time to include on the x-axis}

\item{xlab.abacus}{the label for the x-axis}

\item{ylab.abacus}{the label for the y-axis}

\item{pch.abacus}{the plotting character for the points on the abacus plot}

\item{col.abacus}{the colour of the rails on the abacus plot}
}
\value{
produces a plot depicting observation times for each subject. No values are returned
}
\description{
Create an abacus plot
Creates an abacus plot, depicting visits per subject over time
}
\details{
This function creates a plot for n randomly sampled individuals from the supplied dataset, with one row per subject and one point per visit. This can be useful for visualising the extent of irregularity in the visit process. For example, with perfect repeated measures data (i.e., no irregularity), the points will line up vertically. With greater irregularity, the points will be randomly scattered over time.
}
\examples{
\dontshow{if (requireNamespace("nlme", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlme)
data(Phenobarb)
Phenobarb$event <- 1-as.numeric(is.na(Phenobarb$conc))
data <- Phenobarb[Phenobarb$event==1,]
abacus.plot(n=20,time="time",id="Subject",data=data,tmin=0,tmax=16*24,
xlab.abacus="Time in hours",pch=16,col.abacus=gray(0.8))
\dontshow{\}) # examplesIf}
}
