% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccsr_changelog.R
\name{ccsr_changelog}
\alias{ccsr_changelog}
\title{Get CCSR Change Log}
\usage{
ccsr_changelog(
  version = "latest",
  type = "diagnosis",
  format = "read",
  as_data_table = NULL
)
}
\arguments{
\item{version}{Character string specifying the CCSR version. Use "latest"
(default) to get the change log for the most recent version, or specify a
version like "v2026.1", "v2025.1", etc.}

\item{type}{Character string specifying the type of CCSR. Must be one of:
"diagnosis" (or "dx") for ICD-10-CM diagnosis codes, or "procedure" (or
"pr") for ICD-10-PCS procedure codes. Default is "diagnosis".}

\item{format}{Character string specifying the output format. Options:
"read" (default) - Downloads and reads the Excel file as a data table/tibble (requires \code{readxl} package)
"text" - Returns change log information as text
"url" - Returns the URL to the change log document
"download" - Downloads and returns the change log file path
"view" - Downloads and opens the change log file in the default viewer
"extract" - Attempts to extract text from the file (requires \code{pdftools} for PDF or \code{readxl} for Excel)}

\item{as_data_table}{Logical. If TRUE, returns a \code{data.table} instead of a tibble.
Only used when \code{format = "read"}. If NULL (default), prompts the user interactively
to choose (only in interactive sessions). In non-interactive sessions, defaults to FALSE.}
}
\value{
Depending on \code{format}:
\itemize{
\item "read" (default): A tibble or data.table containing the change log data (if Excel file)
\item "text": Character string with change log information
\item "url": Character string with URL to change log
\item "download": Character string with path to downloaded file
\item "view": Opens the file and returns the file path (invisibly)
\item "extract": Character string with extracted text from file
}
}
\description{
Retrieves and displays the change log for CCSR versions. The change log
documents updates, additions, and modifications to CCSR categories across
different versions.
}
\details{
CCSR change logs document:
\itemize{
\item New CCSR categories added
\item Categories that were removed or merged
\item Changes to category descriptions
\item Updates to ICD-10 code mappings
\item Version-specific notes and improvements
}

Change logs are typically available as PDF or text documents on the HCUP
website. This function attempts to locate and retrieve them.
}
\examples{
\donttest{
# Get latest change log URL
changelog_url <- ccsr_changelog(format = "url")

# Get change log information
changelog_info <- ccsr_changelog(version = "v2026.1", format = "text")

# Download change log file
changelog_file <- ccsr_changelog(version = "v2025.1", format = "download")

# View change log in default PDF viewer
ccsr_changelog(version = "v2026.1", format = "view")

# Extract text from change log PDF (requires pdftools package)
changelog_text <- ccsr_changelog(version = "v2026.1", format = "extract")
cat(changelog_text)
}

}
