% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_search.R
\name{initOptimalExperimentalDesignObject}
\alias{initOptimalExperimentalDesignObject}
\title{Begin a Search for the Optimal Solution}
\usage{
initOptimalExperimentalDesignObject(
  X = NULL,
  objective = "mahal_dist",
  Kgram = NULL,
  wait = FALSE,
  start = TRUE,
  num_cores = 1,
  verbose = TRUE,
  use_safe_inverse = FALSE
)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{objective}{The objective function to use when searching design space. This is a string
with valid values "\code{mahal_dist}" (the default), "\code{abs_sum_diff}" or "\code{kernel}".}

\item{Kgram}{If the \code{objective = kernel}, this argument is required to be an \code{n x n} matrix whose
entries are the evaluation of the kernel function between subject i and subject j. Default is \code{NULL}.}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
deafult is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}

\item{verbose}{Should the algorithm emit progress output? Default is \code{TRUE}.}

\item{use_safe_inverse}{Should a regularized inverse be used for the Mahalanobis objective?
Default is \code{FALSE}.}
}
\value{
An object of type \code{optimal_experimental_design_search} which can be further operated upon
}
\description{
This method creates an object of type optimal_experimental_design and will immediately initiate
a search through allocation space. Since this search takes exponential time, for most machines, 
this method is futile beyond 28 samples. You've been warned! For debugging, you can use set 
\code{num_cores = 1} to be assured of deterministic output.
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(12), nrow = 6)
obj = initOptimalExperimentalDesignObject(
  X,
  objective = "abs_sum_diff",
  num_cores = 1,
  start = TRUE,
  wait = TRUE,
  verbose = FALSE
)
obj
}
}
\author{
Adam Kapelner
}
