% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mean_boot.R
\name{dist_mean_boot}
\alias{dist_mean_boot}
\title{Bootstrapped distance between two arrays}
\usage{
dist_mean_boot(A, B, boot = 1000, ci = 0.95, nA = nrow(A), nB = nrow(B))
}
\arguments{
\item{A, B}{Matrices or data frames containing data
(observations in rows, variables in columns).}

\item{boot}{number of bootstrap resamples}

\item{ci}{width of the confidence interval}

\item{nA, nB}{sample sizes for each bootstrapped group (defaults to original sample size)}
}
\value{
The function outputs a named vector with the mean, median, upper and lower confidence interval bounds
obtained from the bootstrapped samples
}
\description{
Computes bootstrapped estimates of the mean distance
between two groups and their confidence intervals.
}
\details{
This may be useful to compare whether the differences between two groups
are larger or smaller than differences between two other groups.

For instance, if we wanted to quantify shape sexual dimorphism in two populations,
we could run this analysis separately for the two populations and then check the
confidence intervals. If the two confidence intervals are disjunct there is evidence
for the two populations having different levels of sexual dimorphism.

The computation performs bootstrap by resampling with replacement
within each of the two groups and at each round computing the Euclidean distance
between the two groups.
It is also possible to resample at a different sample size than the one in the data
using the attributes nA and nB.

Notice that the confidence interval is expressed on a scale between 0 and 1 and not
as a percentage (e.g., 0.95 means 95% confidence interval)
}
