% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EscoufierRVrarefy.R
\name{EscoufierRV}
\alias{EscoufierRV}
\title{Escoufier RV coefficient}
\usage{
EscoufierRV(Block1, Block2)
}
\arguments{
\item{Block1, Block2}{Matrices or data frames
containing each block of variables
(observations in rows, variables in columns).}
}
\value{
The function returns a number, corresponding to the Escoufier RV coefficient
}
\description{
Computes the Escoufier RV coefficient
}
\details{
This function computes the usual version of the Escoufier RV coefficient (Escoufier, 1973),
which quantifies the level of association between two multivariate blocks
of variables. The function accepts two blocks of variables, either two data frames
or two matrices each of n observations (specimens) as rows.
The two blocks must have the same number of rows (specimens), but can have
different number of columns (variables, such as landmark coordinates).
The Escoufier RV has been shown (Fruciano et al. 2013) to be affected
by sample size so comparisons of groups (e.g., species, populations)
with different sample size should be avoided, unless steps are taken to account
for this problem
}
\examples{
library(MASS)
set.seed(123)
A=mvrnorm(100,mu=rep(0,100), Sigma=diag(100))
# Create a sample of 100 'individuals'
# as multivariate normal random data
# We will consider the first 20 columns as the first
# block of variables, and the following one as the second block

EscoufierRV(A[,1:20],A[,21:ncol(A)])
# Compute the EscoufierRV using the two blocks of variables

}
\references{
Escoufier Y. 1973. Le Traitement des Variables Vectorielles. Biometrics 29:751-760.

Fruciano C, Franchini P, Meyer A. 2013. Resampling-Based Approaches to Study Variation in Morphological Modularity. PLoS ONE 8:e69376.
}
\seealso{
\code{\link{RVrarefied}}
}
