% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_tag_data.R
\name{import_tag_data}
\alias{import_tag_data}
\title{Load time-depth series data from csv file}
\usage{
import_tag_data(
  tag_ID,
  tag_deploy_UTC,
  tag_release_UTC,
  archive,
  date_time_col = 1,
  depth_col = 2,
  temp_col = NA,
  time_zone,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tag_ID}{Unique tag identification number in a vector of characters.
E.g. "123456"}

\item{tag_deploy_UTC}{UTC deployment time in the allowed \code{POSIXct} format:
E.g. "2013-10-25 02:46:00"}

\item{tag_release_UTC}{UTC release time in the allowed \code{POSIXct} format: E.g.
"2014-04-23 23:17:35"}

\item{archive}{File path of the time-series depth archive. E.g. ("C:/Tag
data/123456/123456-Archive.csv")}

\item{date_time_col}{Column number of the date time series}

\item{depth_col}{Column number of the depth series}

\item{temp_col}{(Optional) Column number of temperature series}

\item{time_zone}{Time zone of the data. E.g. "Asia/Tokyo"}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A data frame of processed tag data. Columns kept are:
\itemize{
\item 'date' a POSIXct date_time object in format "yyyy-mm-dd hh:mm:ss"
\item 'depth' numerical depth data
\item 'temp' numerical temperature data
\item 'date_only' an as.Date version of the 'date' column
\item An attribute 'time_zone' is added to the date frame containing the time zone of the 'date'
}
}
\description{
\code{import_tag_data} processes the time-series depth data of marine animal tags.
Data to import should be a csv file with a 'date_time' column and a depth
column. Data is cropped by deployment and release times.
}
\details{
Data are cropped to full days from midnight to midnight in local time based on
the time zone supplied. If \code{output = TRUE}, the cropped data are saved as
\code{archive_days.rds} within \code{output_folder}.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Run import_tag_data function on tag archive csv file
archive_days <- import_tag_data(
  tag_ID = "data",
  tag_deploy_UTC = "2000-01-01 00:00:00",
  tag_release_UTC = "2000-01-11 23:59:00",
  archive = file.path(filepath, "data/data-Archive.csv"),
  date_time_col = 1,
  depth_col = 2,
  temp_col = NA,
  time_zone = "Asia/Tokyo",
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
