% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_eviews_path.R
\name{set_eviews_path}
\alias{set_eviews_path}
\title{Set \code{EViews} path}
\usage{
set_eviews_path(engine_path = "eviews")
}
\arguments{
\item{engine_path}{Path to the EViews executable}
}
\value{
Character
}
\description{
Use this function to set \code{EViews} path. It is only useful when the \code{EViews} is not installed in standard directory, or when there are multiple \code{EViews} executables and the user wants to use older version of \code{EViews}.
}
\examples{
library(EviewsR)
\dontrun{
set_eviews_path('C:/Program Files (x86)/EViews 10/eviews10.exe')
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()}
}
\concept{important functions}
\keyword{documentation}
