% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedSystematicError.R
\name{compareEase}
\alias{compareEase}
\title{Compare EASE of correlated sets of estimates}
\usage{
compareEase(
  logRr1,
  seLogRr1,
  logRr2,
  seLogRr2,
  alpha = 0.05,
  sampleSize = 1000
)
}
\arguments{
\item{logRr1}{A numeric vector of effect estimates generated using the first method on the log scale.}

\item{seLogRr1}{The standard error of the log of the effect estimates generated using the first method.}

\item{logRr2}{A numeric vector of effect estimates generated using the second method on the log scale.}

\item{seLogRr2}{The standard error of the log of the effect estimates generated using the second method.}

\item{alpha}{The expected type I error for computing confidence intervals and p-values.}

\item{sampleSize}{The number of samples in the bootstraps.}
}
\value{
A data frame with 4 columns: the point estimate, confidence interval lower bound, and upper bound for the difference
between EASE in the two sets of negative controls, and a p value against the null hypothesis that the EASE is the
same for the two sets.

The data frame has two attributes: ease1 and ease2, providing the EASE estimates (and confidence intervals) for the
two sets, computed using bootstrapping. Note that these estimates may somewhat different from those generated using
\code{\link{computeExpectedAbsoluteSystematicError}}, because a different approach is used to compute the confidence
interval. The approach used here will more closely align with the computation of the difference in EASE.
}
\description{
Compare EASE of correlated sets of estimates
}
\details{
Compare the expected absolute systematic error (EASE) of two sets of estimates for the same set of negative controls.

Important: the two sets of estimates (logRr1 + seLogRr1 and logRr2 + seLogRr2) should be in identical order, so that for
example the first item in each vector corresponds to the same negative control.
}
\examples{
# Simulate results of first method:
ncs1 <- simulateControls(n = 50)

# Simulate second method to be more biased:
ncs2 <- ncs1
ncs2$logRr <- ncs2$logRr + rnorm(nrow(ncs2), mean = 0.1, sd = 0.1)

delta <- compareEase(
  logRr1 = ncs1$logRr,
  seLogRr1 = ncs1$seLogRr,
  logRr2 = ncs2$logRr,
  seLogRr2 = ncs2$seLogRr
)
delta
attr(delta, "ease1")
attr(delta, "ease2")
}
