% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdf_niche.R
\name{ecdf_niche}
\alias{ecdf_niche}
\title{Niche analysis using ECDF and chi-squared}
\usage{
ecdf_niche(
  n,
  n_population = 10000L,
  sample_sizes = seq(20L, 500L, 20L),
  seed = NULL
)
}
\arguments{
\item{n}{Integer; number of predictor variables (dimensions).}

\item{n_population}{Integer; size of simulated environmental population.}

\item{sample_sizes}{Integer vector of sample sizes to evaluate.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A list with:
\itemize{
\item corplot: ggplot object with correlation vs sample size.
\item sample_data: matrix of simulated sample points.
\item sample_niche: numeric vector of “true” niche suitability.
\item chisq_suits: numeric vector, 1 - pchisq(Mahalanobis).
\item ecdf_suits: numeric vector, 1 - ECDF(Mahalanobis).
\item mahal_dists: numeric vector of Mahalanobis distances.
}
}
\description{
Simulate niche suitability from Mahalanobis distance using both
chi-squared and empirical CDF transformations, for a given number
of predictor variables.
}
\examples{
# Create ECDF-niche based on personalized options:
ecdf_niche <- ecdf_niche(n = 3,
                         n_population = 20000,
                         sample_sizes = seq(50, 1000, 50),
                         seed = 123)

}
