% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_bottlenecks.R
\name{find_bottlenecks}
\alias{find_bottlenecks}
\title{Finds the bottlenecks in the plan of study based on prerequisite relationships}
\usage{
find_bottlenecks(
  plan_of_study,
  min_prereq = 3,
  min_postreq = 3,
  min_connections = 5,
  include_coreqs = TRUE
)
}
\arguments{
\item{plan_of_study}{igraph object - An igraph object created using the create_plan_of_study function}

\item{min_prereq}{numeric - minimum number of prerequisites defining a bottleneck}

\item{min_postreq}{numeric - minimum number of courses the given course is a prerequisite for}

\item{min_connections}{numeric - minimum total of the number of prerequisites}

\item{include_coreqs}{boolean - default is TRUE, treats corequisites as prerequisites
and the number of courses the given course is a prerequisite for}
}
\value{
atomic vector - list of courses meeting at least one condition of the three parameters
}
\description{
This function takes in a plan of study and three parameters. In this case, we
choose min_prereq,min_postreq, and min_connections. The value of min_prereq is the minimum number of prerequisites defining
a bottleneck (in the user's perspective), whereas min_postreq is the minimum number of courses
the given course is a prerequisite for. Finally, min_connections is the minimum total of the number of prerequisites
and the number of courses the given course is a prerequisite for. A course is a bottleneck if it meets
at least one of the parameters
}
\details{
Suggested values for typical usage is find_bottleneck(x,3,3,5), which are #' provided by default.
Note that min_connections >= min_prereq + min_postreq - 2. If this is violated, a warning is
provided and corrected to the suggested minimum value of min_prereq + min_postreq - 2.

The output is an atomic vector of possible bottlenecks based on the user-defined parameters.
}
