% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogue.R
\name{cds_list_datasets}
\alias{cds_list_datasets}
\alias{cds_search_datasets}
\title{List or search Climate Data Service datasets}
\usage{
cds_list_datasets(dataset, ...)

cds_search_datasets(search, keywords, page = 0, limit = 50, ...)
}
\arguments{
\item{dataset}{A specific dataset for which to list details. If missing
all datasets are listed.}

\item{...}{Ignored}

\item{search}{A string containing free text search terms to look for in the available datasets.}

\item{keywords}{A (vector of) string containing specific keywords. Should be listed in
\code{cds_catalogue_vocabulary()}}

\item{page}{When there are more search results than \code{limit}, results are paginated.
Use \code{page} to specify which page to return starting at \code{0} (default).}

\item{limit}{Use to limit the number of search results. Defaults to \code{50}.}
}
\value{
A \code{data.frame} listing the datasets from the Climate Data Service. In
case of \code{cds_search_datasets()}, attributes named \code{SearchMeta} are added containing
the number of matching and number of returned datasets.
}
\description{
This will help you decide which datasets you wish to obtain.
}
\examples{
if (interactive()) {
  cds_list_datasets()
  cds_search_datasets("rain", "Temporal coverage: Future")
}
}
