% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC_CoFM.R
\name{PC_CoFM}
\alias{PC_CoFM}
\title{Perform PCA-based Factor Estimation for CoFM}
\usage{
PC_CoFM(data, m, A, D)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p). Usually the \code{$data} output
from \code{CoFM}.}

\item{m}{Integer. The number of principal components (factors) to retain.}

\item{A}{Matrix. The true factor loadings matrix (p x m). Usually \code{$True_Params$A}
from \code{CoFM}.}

\item{D}{Matrix. The true uniquenesses matrix (p x p). Usually \code{$True_Params$D}
from \code{CoFM}.}
}
\value{
A list containing:
\item{A2}{Estimated factor loadings matrix.}
\item{D2}{Estimated uniquenesses matrix.}
\item{MSESigmaA}{Mean Squared Error for factor loadings.}
\item{MSESigmaD}{Mean Squared Error for uniquenesses.}
\item{LSigmaA}{Relative loss metric for factor loadings.}
\item{LSigmaD}{Relative loss metric for uniquenesses.}
}
\description{
This function performs Principal Component Analysis (PCA) on the correlation matrix
of the data to estimate factor loadings and uniquenesses. It is designed to work with
data generated by the \code{\link{CoFM}} function and calculates error metrics (MSE and
relative loss) by comparing estimates against the true parameters.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# 1. Generate toy data using CoFM
sim_result <- CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2.0)

# 2. Extract true parameters and observed data
true_A <- sim_result$True_Params$A
true_D <- sim_result$True_Params$D
obs_data <- sim_result$data

# 3. Apply PC method to estimate parameters and compute errors
pc_result <- PC_CoFM(data = obs_data, m = 2, A = true_A, D = true_D)

# 4. Inspect results
pc_result$MSESigmaA
pc_result$MSESigmaD
head(pc_result$A2)
}
