% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.r
\name{roi_segment_ebimage}
\alias{roi_segment_ebimage}
\title{Automated ROI Segmentation via EBImage}
\usage{
roi_segment_ebimage(
  img_obj,
  method = "otsu",
  keep_largest = TRUE,
  morphology = TRUE
)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{method}{String. The thresholding algorithm. Currently, only \code{"otsu"} is supported.}

\item{keep_largest}{Logical. If \code{TRUE} (default), keeps only the largest connected object
and converts all other clusters to background (\code{NA}). This is a powerful
denoising step for animal experiments.}

\item{morphology}{Logical. If \code{TRUE} (default), applies morphological opening and closing
operations to smooth edges and reduce noise.}
}
\value{
A 'BioThermR' object where the \code{processed} matrix has been masked
        (background pixels are set to \code{NA}).
}
\description{
Performs automated background removal using a hybrid pipeline of global thresholding
             (Otsu's method), morphological operations, and connected component analysis.
}
\details{
The segmentation pipeline consists of four steps:
         \enumerate{
           \item \strong{Normalization:} The temperature matrix is scaled to [0, 1] to be compatible with 'EBImage'.
           \item \strong{Thresholding:} Otsu's method is used to calculate an optimal global threshold
                 that separates the foreground (subject) from the background based on histogram bimodality.
           \item \strong{Morphology:} A disc-shaped brush (size=5) is used for 'Opening' (to remove salt noise)
                 and 'Closing' (to fill small holes inside the subject).
           \item \strong{Component Filter:} If \code{keep_largest} is \code{TRUE}, the function labels all
                 connected regions and retains only the largest one (assuming the animal is the largest heat source),
                 effectively removing smaller artifacts like bedding noise or reflections.
         }
}
\examples{
# Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)

# Apply automated segmentation
img <- roi_segment_ebimage(img, keep_largest = TRUE)
}
