% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdImputeSNPs_hdf5}
\alias{bdImputeSNPs_hdf5}
\title{Impute Missing SNP Values in HDF5 Dataset}
\usage{
bdImputeSNPs_hdf5(
  filename,
  group,
  dataset,
  outgroup = NULL,
  outdataset = NULL,
  bycols = TRUE,
  paral = NULL,
  threads = NULL,
  overwrite = NULL
)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Path to the group containing input dataset.}

\item{dataset}{Character string. Name of the dataset to impute.}

\item{outgroup}{Character string (optional). Output group path. If NULL,
uses input group.}

\item{outdataset}{Character string (optional). Output dataset name. If NULL,
overwrites input dataset.}

\item{bycols}{Logical (optional). Whether to impute by columns (TRUE) or
rows (FALSE). Default is TRUE.}

\item{paral}{Logical (optional). Whether to use parallel processing.}

\item{threads}{Integer (optional). Number of threads for parallel processing.}

\item{overwrite}{Logical (optional). Whether to overwrite existing dataset.}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the imputed data (group/dataset)}
}
}
\description{
Performs imputation of missing values in SNP (Single Nucleotide Polymorphism)
data stored in HDF5 format.
}
\details{
This function provides efficient imputation capabilities for genomic data with
support for:
\itemize{
\item Imputation options:
\itemize{
\item Row-wise or column-wise imputation
\item Parallel processing
\item Configurable thread count
}
\item Output options:
\itemize{
\item Custom output location
\item In-place modification
\item Overwrite protection
}
\item Implementation features:
\itemize{
\item Memory-efficient processing
\item Safe file operations
\item Error handling
}
}

The function supports both in-place modification and creation of new datasets.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test data with missing values
data <- matrix(sample(c(0, 1, 2, NA), 100, replace = TRUE), 10, 10)

# Save to HDF5
fn <- "snp_data.hdf5"
bdCreate_hdf5_matrix(fn, data, "genotype", "snps",
                     overwriteFile = TRUE)

# Impute missing values
bdImputeSNPs_hdf5(
  filename = fn,
  group = "genotype",
  dataset = "snps",
  outgroup = "genotype_imputed",
  outdataset = "snps_complete",
  bycols = TRUE,
  paral = TRUE
)

# Cleanup
if (file.exists(fn)) {
  file.remove(fn)
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
\item Li, Y., et al. (2009). Genotype Imputation. Annual Review of Genomics
and Human Genetics, 10, 387-406.
}
}
\seealso{
\itemize{
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
