#' Evapotranspiration data
#'
#' This is a dataset compiled by Sadras & Angus (2006) that is comprises measures of
#' wheat yield and estimated evapotranspiration (ET) from sites in China, the
#' Mediterranean regions of Europe, North America, and Australia. For more details about
#' this dataset refer to Sadras & Angus (2006).
#'
#'
#' @format A data.frame with 691 rows and 3 columns:
#' \describe{
#' \item{Region}{ Location of measurement}.
#' \item{ET (mm)}{ Evapotranspiration measurement(mm) measured}.
#' \item{Yield (t/ha)}{ Wheat yield (ton/ha) measured}.
#' }
#’
#' @source Sadras, V. O., & Angus, J. F. (2006). Benchmarking water-use efficiency of
#' rainfed wheat in dry environments. Australian Journal of Agricultural Research, 57 ,
#' 847-856.
#'
#' @details
#' This data set should only be used for illustration purposes for this package and
#' should not be used in any form publication without permission from the owners.
#' @examples
#' data(evapotranspiration)
 "evapotranspiration"
