% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCFM.model.selection.R
\name{BCFM.model.selection}
\alias{BCFM.model.selection}
\title{BCFM Model Selection Over Multiple Groups and Factors}
\usage{
BCFM.model.selection(
  data,
  cluster.vars,
  grouplist,
  factorlist,
  n.iter = 50000,
  vague.mu = FALSE,
  covariance = TRUE,
  p.exponent = 2,
  every = 10,
  cluster.size = 0.05,
  burnin = NA,
  output_dir = tempdir(),
  seed = NULL
)
}
\arguments{
\item{data}{A data frame containing the variables to be analyzed}

\item{cluster.vars}{A character vector specifying the column names of variables
to be used for clustering}

\item{grouplist}{A numeric vector specifying the numbers of groups to test
(e.g., c(2, 3, 4, 5))}

\item{factorlist}{A numeric vector specifying the numbers of latent factors
to test (e.g., c(1, 2, 3))}

\item{n.iter}{Number of MCMC iterations for each model. Default is 50000.}

\item{vague.mu}{Logical indicating whether to use vague priors for mu.
Default is FALSE.}

\item{covariance}{Logical indicating whether to model covariance structure.
Default is TRUE.}

\item{p.exponent}{The Dirichlet priors exponent for probabilities. Default is 2.}

\item{every}{Integer specifying the frequency of progress updates during MCMC.
Default is 10.}

\item{cluster.size}{Minimum proportion required for each cluster. Default is 0.05.}

\item{burnin}{Number of initial MCMC iterations to discard when calculating IC.
If NA, an appropriate burnin is determined automatically.}

\item{output_dir}{Directory where results will be saved. Defaults to
\code{tempdir()}. The function will create this directory if it doesn't exist.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
Invisibly returns NULL. Results are saved to disk:
\describe{
\item{results-covarianceF-gX-fY.Rdata}{Individual model results for
each group-factor combination (where X is the number of groups and Y is
the number of factors), containing SDresult and variable order}
\item{IC.Rdata}{Contains IC.matrix, timing information, and data.
Load this file to compare models and identify the optimal configuration.}
}
}
\description{
Performs Bayesian Clustering Factor Models analysis across a grid
of group numbers and factor numbers. For each combination, the function fits
the BCFM model, calculates IC, and saves results. This is the primary function
for model selection to determine the optimal number of clusters and latent factors.
}
\details{
The function performs the following steps for each group-factor combination:
\enumerate{
\item Preprocesses data using init.data
\item Determines optimal variable ordering using permutation.order
\item Initializes model attributes and hyperparameters
\item Fits BCFM model using BCFM.fit
\item Calculates IC for model comparison
\item Saves individual results and cumulative IC matrix
}

The IC matrix can be used to identify the optimal model configuration by
selecting the combination of groups and factors with the lowest IC value.
}
\note{
This function can be computationally intensive as it fits multiple models.
Consider running on high-performance computing resources for large datasets or
extensive model grids. The function includes error handling to continue execution
even if individual models fail to converge.
}
\examples{
\donttest{
# Run model selection using the included simulated dataset
data(sim.data)
BCFM.model.selection(
  data = sim.data,
  cluster.vars = paste0("V", 1:5),
  grouplist = 2:3,
  factorlist = 1:2,
  n.iter = 100,
  every = 10,
  burnin = 10
)

# Load and examine IC results
load(file.path(tempdir(), "IC.Rdata"))
print(IC.matrix)
}

}
\seealso{
\code{\link{BCFM.fit}} for fitting a single model,
\code{\link{init.data}}, \code{\link{initialize.model.attributes}},
\code{\link{initialize.hyp.parm}}
}
