% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_donut_usage_action.R
\name{get_donut_usage_action}
\alias{get_donut_usage_action}
\title{Donut chart usage possessions action}
\usage{
get_donut_usage_action(data_usage_act, team_sel, type_play, 
                       language, min_poss, min_perc, size_orl,
                       size_irl = 4, vjust_title = 1)
}
\arguments{
\item{data_usage_act}{Data frame with the number of possessions that each 
player ended and the particular action used.}

\item{team_sel}{String with the team's full name.}

\item{type_play}{Play type. Options are 'one' for free throws, 
'two' for two-point field goals and 'three' for three-point 
field goals and 'tov' for turnovers.}

\item{language}{Language of the titles. Valid options are 'English' 
and 'Spanish' so far.}

\item{min_poss}{Minimum number of possessions played.}

\item{min_perc}{Minimum percentage achieved.}

\item{size_orl}{Size of the outer ring labels.}

\item{size_irl}{Size of the inner ring labels.}

\item{vjust_title}{Adjust the title vertically when representing turnovers.}
}
\value{
A donut chart.
}
\description{
This function creates a donut chart that displays the percentage of 
possessions that each player of a team ends with a particular action
(turnover, field goal attempted or free throw attempted) while being 
on the court.
}
\details{
Donut charts are an alternative for pie charts, which have a hole 
in the middle, making them cleaner to read than pie charts.
}
\examples{
\dontrun{
get_donut_usage_action(acb_usage_act_data_2526, "Valencia Basket", "two", "English", 1, 1, 3)
# For example, the interpretation here is that Sako finishes the 66.67\% of his possessions
# scoring a two-point shot.

get_donut_usage_action(acb_usage_act_data_2526, "Valencia Basket", "tov", "English", 1, 1, 5)
}

}
\seealso{
\code{\link{get_donut_usage}}
}
\author{
Guillermo Vinue with the help of ChatGPT.
}
