% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{submit_query}
\alias{submit_query}
\title{Submit a query}
\usage{
submit_query(zoltar_connection, project_url, query_type, query)
}
\arguments{
\item{zoltar_connection}{A \code{ZoltarConnection} object as returned by \code{\link[=new_connection]{new_connection()}}}

\item{project_url}{URL of a project in zoltar_connection's projects}

\item{query_type}{A character indicating the type of query to run. Must be one of: "forecasts" or "truth".}

\item{query}{A \code{list} of character \code{list}s that constrains the queried data. It is the analog of
the JSON object documented at \url{https://docs.zoltardata.com/}. The keys vary depending on query_type. References
to models, units, targets, and timezeros are strings that name the objects, and not IDs.}
}
\value{
a Job URL for tracking the query and getting its results when it successfully completes
}
\description{
Submits a request for the execution of a query of either forecasts or truth in this Project.
}
\examples{
\dontrun{
  job_url <- submit_query(conn, "https://www.zoltardata.com/api/project/9/", "forecasts",
                          list("models"=list("60-contact", "CovidIL_100"), "units"=list("US"),
                          "targets"=list(1894, 1897), "timezeros"=list("2020-05-14", "2020-05-09"),
                          "types"=list("point", "quantile")))
}
}
