% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zVarArrayError.R
\name{zVarArrayError}
\alias{zVarArrayError}
\title{Variation array relative error}
\usage{
zVarArrayError(
  X,
  label = 0,
  groups = NULL,
  breakdown = FALSE,
  suppress.print = FALSE
)
}
\arguments{
\item{X}{Compositional data set (\code{\link{matrix}} or \code{\link{data.frame}} class).}

\item{label}{Unique label (\code{\link{numeric}} or \code{\link{character}}) used to denote zeros/unobserved data in \code{X} (\code{label = 0}, default).}

\item{groups}{Grouping factor in fully observed zero-free data sets (\code{groups = NULL}, default).}

\item{breakdown}{Logical value. Show results broken down by group (\code{breakdown = FALSE}, default).}

\item{suppress.print}{Suppress printed feedback (\code{suppress.print = FALSE}, default).}
}
\value{
1. SRE for each log-ratio variance and mean.
2. Weighted SRE for each log-ratio variance and mean.
3. Total SRE across log-ratio variances and means.
4. Percentage contribution of each log-ratio to SRE in log-ratio variances and means.
If \code{breakdown = TRUE}:
4. SREs per group.
5. Weighted SREs per group.
6. Percentage contribution of each group to total SRE.
}
\description{
This function computes squared relative errors of variation arrays per group with respect to the overall variation array
based on observed data in a compositional data set. Groups can be defined by either zero/unobserved data patterns or
by a grouping factor in fully observed zero-free data sets.
}
\details{
Squared relative errors (SRE) are calculated by confronting variation arrays (log-ratio variances and means) obtained per group and
the overall variation array based on observed data. Raw SREs are computed for each available pair-wise log-ratio. The weighted version uses
the corresponding group sizes to weight raw SREs. Total SRE is obtained as the sum of weighted SREs for each log-ratio. Further details by group are
provided by setting \code{breakdown = TRUE}.
}
\examples{
data(Water)
zPatterns(Water, label = 0)
zVarArrayError(Water)
zVarArrayError(Water, breakdown = TRUE)

# From a completed data set

data(mdl) # matrix of limits of detection for Water
Water_multKM <- multKM(Water,label=0,dl=mdl) # nondetects imputation

# Results split by two ficticious groups A and B
zVarArrayError(Water_multKM,groups=rep(c("A","B"),each=50))
}
\seealso{
\code{\link{zPatterns}}, \code{\link{zVarArray}}.
}
