% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDeliveryWickets.R
\name{getDeliveryWickets}
\alias{getDeliveryWickets}
\title{Get datframe of deliveries bowled and wickets taken}
\usage{
getDeliveryWickets(team,dir=".",name,save=FALSE)
}
\arguments{
\item{team}{The team for which dataframe is to be obtained}

\item{dir}{The source directory in which the match .RData files exist}

\item{name}{The name of the bowler}

\item{save}{Whether the data frame needs to be saved to a file or nor}
}
\value{
dataframe
The dataframe of delivery wickets
}
\description{
This function  creates a data frame of deliveries bowled and wickets taken. This data frame is
then used by bowlerWktsPredict to predict the number of deliveries to wickets taken
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Create a data frame of deliveries to wickets from the stored .RData files
jadeja1 <- getDeliveryWickets(team="India",dir="../data",name="Jadeja",save=FALSE)

# Use this to create a classification tree of deliveries to wickets
bowlerWktsPredict(jadeja1,"RA Jadeja")
}

}
\author{
Tinniam V Ganesh
}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{bowlerMovingAverage}}\cr
\code{\link{getTeamBowlingDetails}}\cr
\code{\link{bowlerWktsPredict}}\cr
\code{\link{teamBowlersWicketRunsOppnAllMatches}}
}

