% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtdml_data.R
\name{xtdml_data_from_data_frame}
\alias{xtdml_data_from_data_frame}
\title{Wrapper for Double machine learning data-backend initialization from
data.frame.}
\usage{
xtdml_data_from_data_frame(
  df,
  x_cols = NULL,
  y_col = NULL,
  d_cols = NULL,
  panel_id = NULL,
  time_id = NULL,
  cluster_cols = NULL,
  approach = NULL,
  transformX = NULL
)
}
\arguments{
\item{df}{(\code{data.frame()})\cr
Data object.}

\item{x_cols}{(\code{character()}) \cr
The covariates.}

\item{y_col}{(\code{character(1)}) \cr
The outcome variable.}

\item{d_cols}{(\code{character()}) \cr
The treatment variable(s).}

\item{panel_id}{(\code{NULL}, \code{character()}) \cr
The panel identifier. Default is \code{NULL}.}

\item{time_id}{(\code{NULL}, \code{character()}) \cr
The time identifier. Default is \code{NULL}.}

\item{cluster_cols}{(\code{NULL}, \code{character()}) \cr
The cluster variables. Default is \code{panel_id}.}

\item{approach}{(\code{character(1)}) \cr
A \code{character()} (\code{"fd-exact"}, \code{"wg-approx"}, \code{"cre"} or \code{"pooled"}) specifying the panel data
technique to apply to estimate the causal model. Default is \code{"NULL"}.}

\item{transformX}{(\code{character(1)}) \cr
A \code{character()} (\code{"no"}, \code{"minmax"} or \code{"poly"}) specifying the type
of transformation to apply to the X data. \code{"no"} does not transform the covariates \code{X}
and is recommended for tree-based learners. \code{"minmax"} applies the Min-Max normalization
\eqn{x' = (x-x_{min})/(x_{max}-x_{min})} to the covariates and is recommended with neural networks.
\code{"poly"} add polynomials up to order three and interactions between all possible
combinations of two and three variables; this is recommended for Lasso.
Default is \code{"no"}.}
}
\value{
Creates a new instance of class \code{xtdml_data}.
}
\description{
Initalization of DoubleMLData from \code{data.frame}.
}
\examples{

# Generate simulated panel dataset from `xtdml`
data = make_plpr_data(n_obs = 500, t_per = 10, dim_x = 30, theta = 0.5, rho=0.8)

# Set up DML data environment
x_cols  = paste0("X", 1:30)

obj_xtdml_data = xtdml_data_from_data_frame(data,
                x_cols = x_cols,  y_col = "y", d_cols = "d",
                panel_id = "id",
                time_id = "time",
                cluster_cols = "id",
                approach = "fd-exact",
                transformX = "no")

obj_xtdml_data$print()


}
