% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineMultFilterNAimput.R
\name{combineMultFilterNAimput}
\alias{combineMultFilterNAimput}
\title{Combine multiple filters on NA-imputed data}
\usage{
combineMultFilterNAimput(
  dat,
  imputed,
  grp,
  annDat = NULL,
  abundThr = NULL,
  colRazNa = NULL,
  colTotNa = NULL,
  minSpeNo = 1,
  minTotNo = 2,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main data (may contain \code{NA})}

\item{imputed}{(character)  same as 'dat' but with all \code{NA} imputed}

\item{grp}{(character or factor) define groups of replicates (in columns of 'dat')}

\item{annDat}{(matrix or data.frame) annotation data (should match lines of 'dat')}

\item{abundThr}{(numeric) optional threshold filter for minimumn abundance}

\item{colRazNa}{(character) if razor peptides are used: column name for razor peptide count}

\item{colTotNa}{(character) column name for total peptide count}

\item{minSpeNo}{(integer) minimum number of specific peptides for maintaining proteins}

\item{minTotNo}{(integer) minimum total ie max razor number of peptides}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
vector of logical values if corresponding line passes filter criteria
}
\description{
In most omics data-analysis one needs to employ a certain number of filtering strategies to avoid getting artifacts to the step of statistical testing.
\code{combineMultFilterNAimput} takes on one side the origial data and on the other side NA-imputed data to create several differnet filters and to finally combine them.
A filter aiming to take away the least abundant values (using the imputede data) is fine-tuned by the argument \code{abundThr}. 
This step compares the means for each group and line, at least one grou-mean has to be > the threshold (based on hypothesis 
that if all conditions represent extrememy low measures their diffrenetial may not be determined with certainty).
In contratst, the filter addressing the number of missing values (\code{NA}) uses the original data, the arguments \code{colTotNa},\code{minSpeNo} and \code{minTotNo} 
are used at this step. Basically, this step allows defining a minimum content of 'real' (ie non-NA) values for further considering the measurements as reliable.
This part uses internally \code{\link[wrMisc]{presenceFilt}} for filtering elevated content of \code{NA} per line.
Finally, this function combines both filters (as matrix of \code{FALSE} and \code{TRUE}) on NA-imputed and original data 
and retruns a vector of logical values if corresponding lines passe all filter criteria.
}
\examples{
set.seed(2013)
datT6 <- matrix(round(rnorm(300)+3,1),ncol=6,dimnames=list(paste("li",1:50,sep=""),letters[19:24]))
datT6 <- datT6 +matrix(rep(1:nrow(datT6),ncol(datT6)),ncol=ncol(datT6))
datT6[6:7,c(1,3,6)] <- NA
datT6[which(datT6 < 11 & datT6 > 10.5)] <- NA
datT6[which(datT6 < 6 & datT6 > 5)] <- NA
datT6[which(datT6 < 4.6 & datT6 > 4)] <- NA
datT6b <- matrixNAneighbourImpute(datT6,gr=gl(2,3))
datT6c <- combineMultFilterNAimput(datT6,datT6b,grp=gl(2,3),abundThr=2)

}
\seealso{
\code{\link[wrMisc]{presenceFilt}}
}
