% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstLineOfDat.R
\name{firstLineOfDat}
\alias{firstLineOfDat}
\title{Filter matrix to keep only first of repeated lines}
\usage{
firstLineOfDat(dat, refCol = 2, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{refCol}{(integer) column number of reference-column}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
matrix (same number of columns as input)
}
\description{
This function aims to reduce the complexity of a matrix (or data.frame) in case column 'refCol' has multiple lines with same value. 
In this case, it reduces the input-data to 1st line of redundant entries and returns a matrix (or data.frame) without lines identified as redundant entries for 'refCol').
in sum, this functions works lile useng \code{unique} on a given column, and propagates the same treatment to all other columns.
}
\examples{
(mat1 <- matrix(c(1:6,rep(1:3,1:3)),ncol=2,dimnames=list(letters[1:6],LETTERS[1:2])))
firstLineOfDat(mat1)
}
\seealso{
\code{\link{firstOfRepeated}}, \code{\link[base]{unique}}, \code{\link[base]{duplicated}}
}
