% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgrrel_matrix.R
\name{mgrrel_matrix}
\alias{mgrrel_matrix}
\title{Manager Relationship 2x2 Matrix}
\usage{
mgrrel_matrix(
  data,
  hrvar = NULL,
  mingroup = 5,
  return = "plot",
  plot_colors = c("#fe7f4f", "#b4d5dd", "#facebc", "#fcf0eb"),
  threshold = 15
)
}
\arguments{
\item{data}{Standard Person Query data to pass through. Accepts a data frame.}

\item{hrvar}{HR Variable by which to split metrics. Accepts a character
vector, e.g. "Organization". Defaults to \code{NULL}.}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
\item \code{"data"}
}

See \code{Value} for more information.}

\item{plot_colors}{Pass a character vector of length 4 containing HEX codes
to specify colors to use in plotting.}

\item{threshold}{Specify a numeric value to determine threshold (in minutes) for 1:1 manager hours.
Defaults to 15.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: ggplot object. When \code{NULL} is passed to \code{hrvar}, a two-by-two
grid where the size of the grid represents total percentage of employees is
returned. Otherwise, a horizontal stacked bar plot is returned.
\item \code{"table"}: data frame. A summary table is returned.
\item \code{"data"}: data frame. A long table grouped at the \code{PersonId} level with
the following columns:
\itemize{
\item \code{PersonId}
\item HR variable supplied to \code{hrvar}
\item \code{CoattendanceRate}
\item \code{Meeting_hours_with_manager_1_on_1}
\item \code{mgr1on1}
\item \code{Type}
}
}
}
\description{
Generate the Manager-Relationship 2x2 matrix, returning a 'ggplot' object by
default. Additional options available to return a "wide" or "long" summary
table.
}
\examples{
# Return matrix
mgrrel_matrix(sq_data)

# Return stacked bar plot
mgrrel_matrix(sq_data, hrvar = "Organization")

## Visualize coaching style types
# Ensure dplyr is loaded
library(dplyr)

# Extract PersonId and Coaching Type
match_df <-
  sq_data \%>\%
  mgrrel_matrix(return = "data") \%>\%
  select(PersonId, Type)

# Join and visualize baseline
sq_data \%>\%
  left_join(match_df, by = "PersonId") \%>\%
  keymetrics_scan(hrvar = "Type",
                  return = "plot")

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar}()},
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_dist}()},
\code{\link{external_fizz}()},
\code{\link{external_line}()},
\code{\link{external_network_plot}()},
\code{\link{external_rank}()},
\code{\link{external_sum}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Managerial Relations: 
\code{\link{mgrcoatt_dist}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()}
}
\author{
Lucas Hogner \href{mailto:lucas.hogner@microsoft.com}{lucas.hogner@microsoft.com}
}
\concept{Managerial Relations}
\concept{Visualization}
