% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bar.R
\name{create_bar}
\alias{create_bar}
\title{Mean Bar Plot for any metric}
\usage{
create_bar(
  data,
  metric,
  hrvar = "Organization",
  mingroup = 5,
  return = "plot",
  bar_colour = "default",
  na.rm = FALSE,
  percent = FALSE,
  plot_title = us_to_space(metric),
  plot_subtitle = paste("Average by", tolower(camel_clean(hrvar))),
  legend_lab = NULL,
  rank = "descending",
  xlim = NULL,
  text_just = 0.5,
  text_colour = "#FFFFFF"
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{metric}{Character string containing the name of the metric,
e.g. "Collaboration_hours"}

\item{hrvar}{String containing the name of the HR Variable by which to split
metrics. Defaults to \code{"Organization"}. To run the analysis on the total
instead of splitting by an HR attribute, supply \code{NULL} (without quotes).}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
}

See \code{Value} for more information.}

\item{bar_colour}{String to specify colour to use for bars.
In-built accepted values include \code{"default"} (default), \code{"alert"} (red), and
\code{"darkblue"}. Otherwise, hex codes are also accepted. You can also supply
RGB values via \code{rgb2hex()}.}

\item{na.rm}{A logical value indicating whether \code{NA} should be stripped
before the computation proceeds. Defaults to \code{FALSE}.}

\item{percent}{Logical value to determine whether to show labels as
percentage signs. Defaults to \code{FALSE}.}

\item{plot_title}{An option to override plot title.}

\item{plot_subtitle}{An option to override plot subtitle.}

\item{legend_lab}{String. Option to override legend title/label. Defaults to
\code{NULL}, where the metric name will be populated instead.}

\item{rank}{String specifying how to rank the bars. Valid inputs are:
\itemize{
\item \code{"descending"} - ranked highest to lowest from top to bottom (default).
\item \code{"ascending"} - ranked lowest to highest from top to bottom.
\item \code{NULL} - uses the original levels of the HR attribute.
}}

\item{xlim}{An option to set max value in x axis.}

\item{text_just}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A numeric value
controlling for the horizontal position of the text labels. Defaults to
0.5.}

\item{text_colour}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} String to specify
colour to use for the text labels. Defaults to \code{"#FFFFFF"}.}
}
\value{
A different output is returned depending on the value passed to the \code{return} argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A bar plot for the metric.
\item \code{"table"}: data frame. A summary table for the metric.
}
}
\description{
Provides an overview analysis of a selected metric by calculating a mean per
metric.
Returns a bar plot showing the average of a selected metric by default.
Additional options available to return a summary table.
}
\examples{
# Return a ggplot bar chart
create_bar(sq_data, metric = "Collaboration_hours", hrvar = "LevelDesignation")

# Change bar colour
create_bar(sq_data,
           metric = "After_hours_collaboration_hours",
           bar_colour = "alert")

# Custom data label positions and formatting
sq_data \%>\%
  create_bar(
    metric = "Meetings",
    text_just = 1.1,
    text_colour = "black",
    xlim = 20)

# Return a summary table
create_bar(sq_data,
           metric = "Collaboration_hours",
           hrvar = "LevelDesignation",
           return = "table")
}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_dist}()},
\code{\link{external_fizz}()},
\code{\link{external_line}()},
\code{\link{external_network_plot}()},
\code{\link{external_rank}()},
\code{\link{external_sum}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Flexible: 
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_density}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_hist}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}
}
\concept{Flexible}
\concept{Visualization}
