% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meeting_extract.R
\name{meeting_extract}
\alias{meeting_extract}
\title{Extract top low-engagement meetings from the Meeting Query}
\usage{
meeting_extract(
  data,
  recurring_only = TRUE,
  top_n = 30,
  fte_month = 180,
  fte_week = 40,
  return = "table"
)
}
\arguments{
\item{data}{Data frame containing a Standard Meeting Query to pass through.}

\item{recurring_only}{Logical value indicating whether to only filter by
recurring meetings.}

\item{top_n}{Numeric value for the top number of results to return in the
output.}

\item{fte_month}{Numeric value for the assumed number of employee hours per
month for conversion calculations. Defaults to 180.}

\item{fte_week}{Numeric value for the assumed number of employee hours per
week for conversion calculations. Defaults to 180.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"table"}
\item \code{"data"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"table"}: data frame. A summary table containing the top \code{n} low
engagement meetings
\item \code{"data"}: data frame. Contains the full computed metrics related to the
top \code{n} low engagement meetings
}
}
\description{
Pass a Standard Meeting Query and extract the top low engagement meetings.
}
\examples{
meeting_extract(mt_data,
                recurring_only = FALSE,
                top_n = 10,
                return = "table")

}
\seealso{
Other Meetings: 
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_skim}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_tm_report}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()}
}
\concept{Meetings}
