% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_test.R
\name{p_test}
\alias{p_test}
\title{Calculate the p-value of the null hypothesis that two outcomes are from the
same dataset}
\usage{
p_test(data, outcome, behavior, paired = FALSE)
}
\arguments{
\item{data}{A Person Query dataset in the form of a data frame.}

\item{outcome}{A string specifying the name of a binary variable, i.e. can
only contain the values 1 or 0. Used to group the two distributions.}

\item{behavior}{A character vector specifying the column to be used as the
behavior to test.}

\item{paired}{Specify whether the dataset is paired or not. Defaults to
\code{TRUE}.}
}
\value{
Returns a numeric value representing the p-value outcome of the test.
}
\description{
Specify an outcome variable and return p-test outputs.
All numeric variables in the dataset are used as predictor variables.
}
\details{
This function is a wrapper around \code{wilcox.test()} from 'stats'.
}
\examples{
# Simulate a binary variable X
# Returns a single p-value
library(dplyr)
sq_data \%>\%
  mutate(X = ifelse(Email_hours > 6, 1, 0)) \%>\%
  p_test(outcome = "X", behavior = "External_network_size")

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{combine_signals}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{pairwise_count}()},
\code{\link{plot_WOE}()},
\code{\link{read_preamble}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{totals_reorder}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
