% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{cite_essential}
\alias{cite_essential}
\title{Essential citations Knit function for 'RStudio'}
\usage{
cite_essential(...)
}
\arguments{
\item{...}{All arguments are passed to \code{\link[rmarkdown]{render}}.}
}
\value{
Returns \code{NULL} invisibly. This
function is called for its side effect of rendering an
'R Markdown' file.
}
\description{
This is a wrapper for \code{\link[rmarkdown]{render}}. First, this function
parses the citations in the document, removing citations
marked with double at sign, e.g.: \code{@@reference2020}. Then, it renders
the file.
}
\examples{
# NOTE: Do not use this function interactively, as in the example below.
# Only specify it as custom knit function in an R Markdown file, like so:
# knit: worcs::cite_all

if (rmarkdown::pandoc_available("2.0")){
  file_name <- tempfile("citeessential", fileext = ".Rmd")
  rmarkdown::draft(file_name,
                   template = "github_document",
                   package = "rmarkdown",
                   create_dir = FALSE,
                   edit = FALSE)
  write(c("", "Optional reference: @reference2020"),
        file = file_name, append = TRUE)
  cite_essential(file_name)
}
}
