% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmCluster.R
\name{lmCluster}
\alias{lmCluster}
\title{Run a Linear Model on the mean intensity over a region of interest}
\usage{
lmCluster(image, mask, fourdOut = NULL, formula, subjData,
  mc.preschedule = TRUE, ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. All clusters must be labeled with integers in the mask passed as an argument}

\item{fourdOut}{To be passed to mergeNifti. This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to lm()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to lm()}
}
\value{
Returns list of models fitted to the mean voxel intensity a region or interest.
}
\description{
This function is able to run a Linear Model using the stats package. 
All clusters must be labeled with integers in the mask passed as an argument.
}
\examples{
image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(1:4, dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25))
fm1 <- "~ x"
models <- lmCluster(image=image, mask=mask, 
              formula=fm1, subjData=covs, ncores = 1)
}

