% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker.R
\name{augment.vetiver_endpoint_sagemaker}
\alias{augment.vetiver_endpoint_sagemaker}
\title{Post new data to a deployed SageMaker model endpoint and augment with predictions}
\usage{
\method{augment}{vetiver_endpoint_sagemaker}(x, new_data, ...)
}
\arguments{
\item{x}{A SageMaker model endpoint object created with \code{\link[=vetiver_endpoint_sagemaker]{vetiver_endpoint_sagemaker()}}.}

\item{new_data}{New data for making predictions, such as a data frame.}

\item{...}{Extra arguments passed to \code{\link[paws.machine.learning:sagemakerruntime_invoke_endpoint]{paws.machine.learning::sagemakerruntime_invoke_endpoint()}}}
}
\value{
The \code{new_data} with added prediction column(s).
}
\description{
Post new data to a deployed SageMaker model endpoint and augment with predictions
}
\examples{

if (FALSE) {
  endpoint <- vetiver_endpoint_sagemaker("sagemaker-demo-model")
  augment(endpoint, mtcars[4:7, -1])
}

}
\seealso{
\code{\link[=predict.vetiver_endpoint_sagemaker]{predict.vetiver_endpoint_sagemaker()}}
}
