% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_auth_github.R
\name{vault_client_auth_github}
\alias{vault_client_auth_github}
\title{Vault GitHub Authentication Configuration}
\description{
Vault GitHub Authentication Configuration

Vault GitHub Authentication Configuration
}
\details{
Interact with vault's GitHub authentication backend.  For more
details, please see the vault documentation at
https://www.vaultproject.io/docs/auth/github.html
}
\examples{
server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()

  client$auth$enable("github")
  # To enable login for members of the organisation "vimc":
  client$auth$github$configure(organization = "vimc")
  # To map members of the "robots" team *within* that organisation
  # to the "defaut" policy:
  client$auth$github$write("development", "default")

  # Once configured like this, if we have a PAT for a member of
  # the "development" team saved as an environment variable
  # "VAULT_AUTH_GITHUB_TOKEN" then doing
  #
  #   vaultr::vault_client(addr = ..., login = "github")
  #
  # will contact GitHub to verify the user token and vault will
  # then issue a client token

  # cleanup
  server$kill()
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_auth_github}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_client_auth_github-new}{\code{vault_client_auth_github$new()}}
\item \href{#method-vault_client_auth_github-custom_mount}{\code{vault_client_auth_github$custom_mount()}}
\item \href{#method-vault_client_auth_github-configure}{\code{vault_client_auth_github$configure()}}
\item \href{#method-vault_client_auth_github-configuration}{\code{vault_client_auth_github$configuration()}}
\item \href{#method-vault_client_auth_github-write}{\code{vault_client_auth_github$write()}}
\item \href{#method-vault_client_auth_github-read}{\code{vault_client_auth_github$read()}}
\item \href{#method-vault_client_auth_github-login}{\code{vault_client_auth_github$login()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_github} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$new(api_client, mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}

\item{\code{mount}}{Mount point for the backend}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-custom_mount"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-custom_mount}{}}}
\subsection{Method \code{custom_mount()}}{
Set up a \code{vault_client_auth_github} object at a
custom mount.  For example, suppose you mounted the \code{github}
authentication backend at \verb{/github-myorg} you might use \code{gh <- vault$auth$github2$custom_mount("/github-myorg")} - this
pattern is repeated for other secret and authentication
backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$custom_mount(mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mount}}{String, indicating the path that the engine is
mounted at.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-configure"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-configure}{}}}
\subsection{Method \code{configure()}}{
Configures the connection parameters for
GitHub-based authentication.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$configure(
  organization,
  base_url = NULL,
  ttl = NULL,
  max_ttl = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{organization}}{The organization users must be part of
(note American spelling).}

\item{\code{base_url}}{The API endpoint to
use. Useful if you are running GitHub Enterprise or an
API-compatible authentication server.}

\item{\code{ttl}}{Duration after which authentication will be expired}

\item{\code{max_ttl}}{Maximum duration after which authentication will
be expired}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-configuration"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-configuration}{}}}
\subsection{Method \code{configuration()}}{
Reads the connection parameters for GitHub-based
authentication.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$configuration()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-write"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-write}{}}}
\subsection{Method \code{write()}}{
Write a mapping between a GitHub team or user and
a set of vault policies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$write(team_name, policies, user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{team_name}}{String, with the GitHub team name}

\item{\code{policies}}{A character vector of vault policies that this
user or team will have for vault access if they match this
team or user.}

\item{\code{user}}{Scalar logical - if \code{TRUE}, then \code{team_name} is
interpreted as a \emph{user} instead.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-read}{}}}
\subsection{Method \code{read()}}{
Write a mapping between a GitHub team or user and
a set of vault policies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$read(team_name, user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{team_name}}{String, with the GitHub team name}

\item{\code{user}}{Scalar logical - if \code{TRUE}, then \code{team_name} is
interpreted as a \emph{user} instead.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_github-login"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_github-login}{}}}
\subsection{Method \code{login()}}{
Log into the vault using GitHub authentication.
Normally you would not call this directly but instead use
\verb{$login} with \code{method = "github"} and proving the \code{token}
argument.  This function returns a vault token but does not
set it as the client token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_github$login(token = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{A GitHub token to authenticate with.}
}
\if{html}{\out{</div>}}
}
}
}
