% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVC_mle.R
\name{SVC_mle_control}
\alias{SVC_mle_control}
\alias{SVC_mle_control.default}
\alias{SVC_mle_control.SVC_mle}
\title{Set Parameters for \code{SVC_mle}}
\usage{
SVC_mle_control(...)

\method{SVC_mle_control}{default}(
  cov.name = c("exp", "sph", "mat32", "mat52", "wend1", "wend2"),
  tapering = NULL,
  parallel = NULL,
  init = NULL,
  lower = NULL,
  upper = NULL,
  save.fitted = TRUE,
  profileLik = FALSE,
  mean.est = c("GLS", "OLS"),
  pc.prior = NULL,
  extract_fun = FALSE,
  hessian = TRUE,
  dist = list(method = "euclidean"),
  parscale = TRUE,
  ...
)

\method{SVC_mle_control}{SVC_mle}(object, ...)
}
\arguments{
\item{...}{Further Arguments yet to be implemented}

\item{cov.name}{(\code{character(1)}) \cr
Name of the covariance function of the GPs. Currently, the following are
implemented: \code{"exp"} for the exponential, \code{"sph"} for
spherical, \code{"mat32"} and \code{"mat52"} for Matern class covariance
functions with smoothness 3/2 or 5/2, as well as \code{"wend1"} and
\code{"wend2"} for Wendland class covariance functions with kappa 1 or 2.}

\item{tapering}{(\code{NULL} or \code{numeric(1)}) \cr
If \code{NULL}, no tapering is applied. If a scalar is given, covariance
tapering with this taper range is applied, for all Gaussian processes
modeling the SVC. Only defined for Matern class covariance functions,
i.e., set \code{cov.name} either to \code{"exp"}, \code{"mat32"}, or
\code{"mat52"}.}

\item{parallel}{(\code{NULL} or \code{list}) \cr
If \code{NULL}, no parallelization is applied. If cluster has been
established, define arguments for parallelization with a list, see
documentation of \code{\link[optimParallel]{optimParallel}}. See Examples.}

\item{init}{(\code{NULL} or \code{numeric(2q+1+p*as.numeric(profileLik))}) \cr
Initial values for optimization procedure. If \code{NULL} is given, an
initial vector is calculated (see Details). Otherwise, the vector is
assumed to consist of q-times (alternating) range and variance,
the nugget variance and if \code{profileLik = TRUE} p mean effects.}

\item{lower}{(\code{NULL} or \code{numeric(2q+1+p*as.numeric(profileLik))}) \cr
Lower bound for \code{init} in \code{optim}. Default \code{NULL} calculates
the lower bounds (see Details).}

\item{upper}{(\code{NULL} or \code{numeric(2q+1+p*as.numeric(profileLik))}) \cr
Upper bound for \code{init} in \code{optim}. Default \code{NULL} calculates
the upper bounds (see Details).}

\item{save.fitted}{(\code{logical(1)}) \cr
If \code{TRUE}, calculates the fitted values and residuals after MLE and
stores them. This is necessary to call \code{\link{residuals}} and
\code{\link{fitted}} methods afterwards.}

\item{profileLik}{(\code{logical(1)}) \cr
If \code{TRUE}, MLE is done over profile Likelihood of covariance
parameters.}

\item{mean.est}{(\code{character(1)}) \cr
If \code{profileLik = TRUE}, the means have to be estimated seperately for
each step. \code{"GLS"} uses the generalized least square estimate while
\code{"OLS"} uses the ordinary least squares estimate.}

\item{pc.prior}{(\code{NULL} or \code{numeric(4)}) \cr
If numeric vector is given, penalized complexity priors are applied. The
order is \eqn{\rho_0, \alpha_\rho, \sigma_0, \alpha_\sigma} to give some
prior believes for the range and the standard deviation of GPs, such that
\eqn{P(\rho < \rho_0) = \alpha_\rho, P(\sigma > \sigma_0) = \alpha_\sigma}.
This regulates the optimization process. Currently, only supported for
GPs with of Matérn class covariance functions. Based on the idea by
Fulgstad et al. (2018) \doi{10.1080/01621459.2017.1415907}.}

\item{extract_fun}{(\code{logical(1)}) \cr
If \code{TRUE}, the function call of \code{\link{SVC_mle}} stops before
the MLE and gives back the objective function of the MLE as well as all
used arguments. If \code{FALSE}, regular MLE is conducted.}

\item{hessian}{(\code{logical(1)}) \cr
If \code{TRUE}, Hessian matrix is computed, see \link[stats]{optim}. This
required to give the standard errors for covariance parameters and to do
a Wald test on the variances, see \code{\link{summary.SVC_mle}}.}

\item{dist}{(\code{list}) \cr
List containing the arguments of \link[stats]{dist} or
\link[spam]{nearest.dist}. This controls
the method of how the distances and therefore dependency structures are
calculated. The default gives Euclidean distances in a \eqn{d}-dimensional
space. Further editable arguments are \code{p, miles, R}, see respective
help files of \link[stats]{dist} or \link[spam]{nearest.dist}.}

\item{parscale}{(\code{logical(1)}) \cr
Triggers parameter scaling within the optimization in \link[stats]{optim}.
If \code{TRUE}, the optional parameter scaling in \code{optim.control} in
function \code{\link{SVC_mle}} is overwritten by the initial value used in
the numeric optimization. The initial value is either computed from the
data or provided by the user, see \code{init} argument above or Details
below. Note that we check whether the initial values are unequal to zero.
If they are zero, the corresponding scaling factor is 0.001. If
\code{FALSE}, the \code{parscale} argument in \code{optim.control} is let
unchanged.}

\item{object}{(\code{SVC_mle}) \cr
The function then extracts the control settings from the function call
used to compute in the given \code{SVC_mle} object.}
}
\value{
A list with which \code{\link{SVC_mle}} can be controlled.
}
\description{
Function to set up control parameters for \code{\link{SVC_mle}}.
In the following, we assume the GP-based SVC model to have \eqn{q} GPs which
model the SVCs and \eqn{p} fixed effects.
}
\details{
If not provided, the initial values as well as the lower and upper
   bounds are calculated given the provided data. In particular, we require
   the median distance between observations, the variance of the response and,
   the ordinary least square (OLS) estimates, see \code{\link{init_bounds_optim}}.

   The argument \code{extract_fun} is useful, when one wants to modify
   the objective function. Further, when trying to parallelize the
   optimization, it is useful to check whether a single evaluation of the
   objective function takes longer than 0.05 seconds to evaluate,
   cf. Gerber and Furrer (2019) \doi{10.32614/RJ-2019-030}. Platform specific
   issues can be sorted out by the user by setting up their own optimization.
}
\examples{
control <- SVC_mle_control(init = rep(0.3, 10))
# or
control <- SVC_mle_control()
control$init <- rep(0.3, 10)

\donttest{
# Code for setting up parallel computing
require(parallel)
# exchange number of nodes (1) for detectCores()-1 or appropriate number
cl <- makeCluster(1, setup_strategy = "sequential")
clusterEvalQ(
  cl = cl,
  {
    library(spam)
    library(varycoef)
  })
# use this list for parallel argument in SVC_mle_control
parallel.control <- list(cl = cl, forward = TRUE, loginfo = TRUE)
# SVC_mle goes here ...
# DO NOT FORGET TO STOP THE CLUSTER!
stopCluster(cl); rm(cl)
}
}
\seealso{
\code{\link{SVC_mle}}
}
\author{
Jakob Dambon
}
