% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covjmcm_hpc.R
\name{covjmcm_hpc}
\alias{covjmcm_hpc}
\title{Calculate the estimation of the covariance of estimated parameters in a HPC model, via the explicit formula.}
\usage{
covjmcm_hpc(object)
}
\arguments{
\item{object}{a fitted joint mean-covariance model of class "jmcmMod", returned by the function \code{jmcm}.}
}
\value{
an estimated covariance matrix of the estimated parameters in a HPC model.
}
\description{
\code{covjmcm_hpc} gives the estimation of the covariance of estimated parameters in a HPC model using
the explicit formula, which is the inverse of the estimated Fisher's information matrix.
}
\examples{
##This may take more than 5s.
\donttest{
cattleA <- cattle[cattle$group=='A', ]
fit.hpc <- jmcm(weight|id|I(ceiling(day/14+1))~1|1,
               data = cattleA, cov.method = "hpc",
               triple = c(8,3,4))
cov.hpc <- covjmcm_hpc(fit.hpc)}
}
\references{
[1] W. Zhang, C. Leng, and C. Y. Tang(2015), "A joint modelling approach for longitudinal studies,"
Journal of the Royal Statistical Society. Series B. 77, 219-238.
}
\seealso{
\code{\link{covjmcm}}, \code{\link{covjmcm_mcd}}, and \code{\link{covjmcm_acd}}
}
