% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxClusterStatsSheet}
\alias{oxClusterStatsSheet}
\title{openxlsx Water Cluster Statistics}
\usage{
oxClusterStatsSheet(wb.name, sheet.name = "ClusterStatistics", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
"ClusterStatistics"}

\item{df}{data.frame containing the results of the \code{GetSimilarityPairs}
function; \emph{e.g.}, \code{h2o.cluster.stats}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the Water
Cluster statistics.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=ConservedWaterStats]{ConservedWaterStats()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxRCSBinfoSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"openxlsx functions"}
