% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.build_nordbord_df}
\alias{.build_nordbord_df}
\title{Build a NordBord test data frame}
\usage{
.build_nordbord_df(records)
}
\arguments{
\item{records}{A list of NordBord test records from the API.}
}
\value{
A \code{data.frame} with one row per NordBord test record.
Internal function (not designed to be used directly by end users)
}
\description{
Internal helper to convert a list of NordBord test records into a tidy \code{data.frame}.
For character columns, \code{NULL} values are replaced with an empty string (\code{""})
to ensure consistent downstream handling.
}
\details{
Special handling is applied for the identifier column: some NordBord API endpoints
return this as \code{profileId}, while others return it as \code{athleteId}.
This function will populate the \code{athleteId} column by taking the first non-empty value
from \code{athleteId} or \code{profileId}, in that order.
}
\keyword{internal}
