% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_groups.R
\name{bitly_retrieve_sorted_links}
\alias{bitly_retrieve_sorted_links}
\title{Retrieve Sorted Bitlinks for Group}
\usage{
bitly_retrieve_sorted_links(
  group_id = NA,
  to_sort_by = "clicks",
  unit = "day",
  units = -1,
  unit_reference = NULL,
  size = 50,
  showRequestURL = F
)
}
\arguments{
\item{group_id}{- a required string | A GUID for a Bitly group}

\item{to_sort_by}{- a required string | Enum: "clicks" | The type of sorting that you would like to do}

\item{unit}{- string | Default: "day", Enum: "minute" "hour" "day" "week" "month" | A unit of time}

\item{units}{- integer | Default: -1 | An integer representing the time units to
query data for. pass -1 to return all units of time.}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for
which to pull metrics. Will default to current time.}

\item{size}{- string |  Default: 50 | The quantity of items to be be returned}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
This will retrieve a paginated response for Bitlinks that are sorted for the Group.
This method returns a combined object which end-user (you) have to further process for your needs.
}
\section{Group}{

Groups are a subdivision within an organization. A user will belong to a group within an organization.
Most actions on our API will be on behalf of a group. For example, when you
shorten a link, it will be on behalf of a user and a group.
}

\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
rg <- bitly_retrieve_sorted_links(group_id = ui$default_group_guid[1])
}

}
\seealso{
\url{https://dev.bitly.com/api-reference#getSortedBitlinks}
}
