% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stirling.R
\docType{data}
\name{stirling_2}
\alias{stirling_2}
\title{Secondary colours of the University of Stirling, Scotland}
\format{
An object of class \code{character} of length 15.
}
\source{
Color definitions are based on \href{https://www.stir.ac.uk}{Stirling}'s 
\href{https://www.stir.ac.uk/brand-bank/visual-assets/colour-palette/}{Brand guide}.
}
\usage{
stirling_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stirling_2} provides 15 secondary colours 
of the \href{https://www.stir.ac.uk}{University of Stirling}, Scotland, UK.
}
\details{
See \href{https://www.stir.ac.uk}{Stirling}'s 
\href{https://www.stir.ac.uk/brand-bank/visual-assets/colour-palette/}{Brand guide} 
for definitions and details.

\code{stirling_2} uses the HEX color definitions.


The \href{https://www.stir.ac.uk}{University of Stirling}'s secondary colour palette 
has been developed to create rhythm, pace and variety. 
It should be used to support the primary colours (\code{\link{stirling_1}}) and 
tertiary colours (\code{\link{stirling_3}}) with a 90% colour weighting.

The primary and secondary colour palettes are made up of colour pairings: 
‘Energy colours’ and ‘Heritage colours’. 
These can be used separately, mixed, or as the pairings suggested.

An additional colour \code{Heritage gold}, defined as Pantone 871 or CMYK 30, 35, 75, 22, 
should only used for printed materials. 

Although an extensive colour palette provides with you many potential colour combinations, 
you must ensure that text is clearly legible and accessible so please select colours carefully. 
For instance, white text on a \code{Heritage green} background works well, 
whereas \code{Heritage berry} text on a \code{Heritage green} background is very difficult to read 
(see \href{https://www.stir.ac.uk/brand-bank/visual-assets/colour-palette/}{Brand guide example}). 

To add flexibility, users can use tints (70%, 50%, 30%) of a chosen colour.
}
\examples{
stirling_2
unikn::seecol(stirling_2, main = "Secondary colours of the University of Stirling") # view palette

}
\seealso{
\code{\link{stirling_1}} for primary colours of the University of Stirling; 
\code{\link{stirling_3}} for tertiary colours of the University of Stirling; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stirling_1}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-09-16.
}
\concept{Scottish university color palettes}
\keyword{datasets}
